/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;
import java.util.Collection;
import java.util.Vector;

public class PolygonFunction
extends GeometryFunction {
    protected Vector<ADQLOperand> coordinates;

    public PolygonFunction(ADQLOperand aDQLOperand, ADQLOperand[] aDQLOperandArray) throws UnsupportedOperationException, NullPointerException, Exception {
        super(aDQLOperand);
        if (aDQLOperandArray == null || aDQLOperandArray.length < 6) {
            throw new NullPointerException("A POLYGON function must have at least 3 2-D coordinates !");
        }
        this.coordinates = new Vector(aDQLOperandArray.length);
        for (int i = 0; i < aDQLOperandArray.length; ++i) {
            this.coordinates.add(aDQLOperandArray[i]);
        }
    }

    public PolygonFunction(ADQLOperand aDQLOperand, Collection<? extends ADQLOperand> collection) throws UnsupportedOperationException, NullPointerException, Exception {
        super(aDQLOperand);
        if (collection == null || collection.size() < 6) {
            throw new NullPointerException("A POLYGON function must have at least 3 2-D coordinates !");
        }
        this.coordinates = new Vector(collection.size());
        this.coordinates.addAll(collection);
    }

    public PolygonFunction(PolygonFunction polygonFunction) throws Exception {
        super(polygonFunction);
        this.coordinates = new Vector(polygonFunction.coordinates.size());
        for (ADQLOperand aDQLOperand : polygonFunction.coordinates) {
            this.coordinates.add((ADQLOperand)aDQLOperand.getCopy());
        }
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new PolygonFunction(this);
    }

    @Override
    public String getName() {
        return "POLYGON";
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return true;
    }

    @Override
    public ADQLOperand[] getParameters() {
        ADQLOperand[] aDQLOperandArray = new ADQLOperand[this.coordinates.size() + 1];
        aDQLOperandArray[0] = this.coordSys;
        for (int i = 0; i < this.coordinates.size(); ++i) {
            aDQLOperandArray[i + 1] = this.coordinates.get(i);
        }
        return aDQLOperandArray;
    }

    @Override
    public int getNbParameters() {
        return this.coordinates.size() + 1;
    }

    @Override
    public ADQLOperand getParameter(int n) throws ArrayIndexOutOfBoundsException {
        if (n == 0) {
            return this.coordSys;
        }
        if (n >= 1 && n <= this.coordinates.size()) {
            return this.coordinates.get(n - 1);
        }
        throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" (" + this.toADQL() + ") !");
    }

    @Override
    public ADQLOperand setParameter(int n, ADQLOperand aDQLOperand) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (aDQLOperand == null) {
            throw new NullPointerException("Impossible to remove only one parameter from the function POLYGON !");
        }
        ADQLOperand aDQLOperand2 = null;
        if (n == 0) {
            aDQLOperand2 = this.coordSys;
            this.setCoordinateSystem(aDQLOperand);
        } else if (n >= 1 && n <= this.coordinates.size()) {
            aDQLOperand2 = this.coordinates.get(n - 1);
            this.coordinates.set(n - 1, aDQLOperand);
        } else {
            throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" (" + this.toADQL() + ") !");
        }
        return aDQLOperand2;
    }
}

